var Webflow = Webflow || [];
Webflow.push(function() {
    $('.video-link').magnificPopup({
        type: 'iframe',
        patterns: {
            vimeo: {
                index: 'vimeo.com/',
                id: '/',
                src: '//player.vimeo.com/video/%id%?autoplay=1'
            },
        },
        callbacks: {
            open: function() {
                $('video').trigger('pause');
            },
            close: function() {
                $('video').trigger('play');
            }
          }
    });    

    $('.family-of-images').slick({
        autoplay: true,
        autoplaySpeed: 4000,
        infinite: true,
        slidesToShow: 1,
        slidesToScroll: 1,
        prevArrow: '<div class="quote-arrow left w-slider-arrow-left" style="display: none;"><div class="icon w-icon-slider-left"></div></div>',
        nextArrow: '<div class="quote-arrow w-slider-arrow-right"><div class="icon w-icon-slider-right"></div></div>'
    });

    $.ajax({
        url: '/news-feed.php',
        type: 'GET',
        dataType: "xml"
    }).done(function(xml) {

        $.each($("item", xml).slice( 0, 3 ), function(i, e) {  
            var itemTitle = ($(e).find("title").text());
            var htmlTitle = $.parseHTML(itemTitle);
            var itemUrl = ($(e).find("link").text());
            var htmlUrl = $.parseHTML(itemUrl);
            var itemDate = ($(e).find("pubDate").text().split(" "));
            if (itemDate && itemDate.length > 0) {
                itemDate = itemDate[2] + " " + itemDate[1] + " " + itemDate[3];
            }
            else {
                itemDate = "";
            }
            //var htmlDate = $.parseHTML(itemDate);

            var itemInfo = '<div class="column w-col w-col-4 w-col-stack first-news-item"><a href="' + itemUrl + '"><div class="separator pull-left mt30"></div><p class="p">' + itemDate + '</p><p class="p mt20">' + itemTitle + '</p></a></div>';

            $('.news-grid').append(itemInfo);                    
        });
        $('.container.news').addClass('news-in');
    });
    
    var feed = "/stock-feed.php";
    $.ajax(feed, {
            accepts: {
                json: "application/json"
            },
            dataType: "json"
        })
        .done(function(data) {
            var stonk = data.GetStockQuoteListResult[0];
            $('.ticker .price').text('$' + stonk.TradePrice);
            $('.ticker .price-change').text('$' + stonk.Change);
            $('.ticker .percent-change').text(stonk.PercChange.toFixed(2) + '%');
            $('.ticker .volume').text(stonk.Volume.toLocaleString('en-US'));
            $('.ticker .high').text('$' + stonk.High);
            $('.ticker .low').text('$' + stonk.Low);
        });

    $('.ticker').jConveyorTicker();

});